<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\Survey;
use App\Models\User;

class SurveySeeder extends Seeder
{
    public function run(): void
    {
        $user = User::where('email', 'admin@eraasoft.online')->first();
        $survey = Survey::create([
            'user_id' => $user->id,
            'title' => 'CES',
            'description' => "أهلاً بيك يا طالب إيراسوفت الجامد!\n\nإحنا في إيراسوفت هدفنا الأول إن تجربتك التعليمية تكون سهلة وممتعة على قد ما نقدر. عشان تساعدنا نحقق ده، يا ريت تجاوب على الأسئلة اللي جاية بخصوص سهولة إنجازك للمهام المختلفة. إجاباتك دي بجد هتفرق معانا وهتساعدنا نحسن خدماتنا على طول.\n\nالتعليمات:\nيا ريت تقيم سهولة كل مهمة على مقياس من 1 لـ 5 حيث:\n1 = صعب جداً / مجهود كبير\n2 = صعب شوية / محتاج مجهود\n3 = عادي / مجهود معقول\n4 = سهل / مجهود بسيط\n5 = سهل جداً / مجهود تقريباً مفيش",
            'slug' => 'ces-survey',
            'status' => 'published',
            'settings' => [
                'show_progress' => true,
                'show_question_numbers' => true,
                'show_section_numbers' => true,
            ]
        ]);

        $scaleOptions = [
            'صعب جداً / مجهود كبير',
            'صعب شوية / محتاج مجهود',
            'عادي / مجهود معقول',
            'سهل / مجهود بسيط',
            'سهل جداً / مجهود تقريباً مفيش',
        ];

        $section1 = $survey->sections()->create([
            'title' => 'المحاضرات والشرح',
            'order' => 1
        ]);

        $section1->questions()->createMany([
            [
                'question_text' => 'إيه مدى سهولة فهمك لشرح المدرب في المحاضرات؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 1
            ],
            [
                'question_text' => 'إيه مدى سهولة وصولك للمحتوى التعليمي والمحاضرات المسجلة على منصة إيراسوفت؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 2
            ],
            [
                'question_text' => 'إيه مدى سهولة إنك تسأل المدرب أو المساعد وتتفاعل معاهم وقت المحاضرات أو بعدها؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 3
            ],
        ]);

        $section2 = $survey->sections()->create([
            'title' => 'الواجبات والمشاريع والتطبيق العملي',
            'order' => 2
        ]);

        $section2->questions()->createMany([
            [
                'question_text' => 'إيه مدى سهولة تسليمك للواجبات أو المشاريع المطلوبة منك على المنصة؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 1
            ],
            [
                'question_text' => 'إيه مدى سهولة إنك تاخد مساعدة أو توجيه لما تقابلك مشكلة وانت بتطبق الواجبات أو المشاريع؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 2
            ],
            [
                'question_text' => 'إيه مدى سهولة فهمك لملاحظات المدرب أو المساعد على واجباتك ومشاريعك؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 3
            ],
        ]);

        $section3 = $survey->sections()->create([
            'title' => 'الدعم والتواصل والمنصة',
            'order' => 3
        ]);

        $section3->questions()->createMany([
            [
                'question_text' => 'إيه مدى سهولة إنك تتواصل مع فريق الدعم الفني أو الإداري في إيراسوفت؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 1
            ],
            [
                'question_text' => 'إيه مدى سهولة إنك تلاقي إجابة أو حل لمشكلتك من فريق الدعم الفني أو الإداري؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 2
            ],
            [
                'question_text' => 'إيه مدى سهولة التعامل مع منصة إيراسوفت التعليمية واستخدامها بشكل عام؟',
                'question_type' => 'radio',
                'question_required' => true,
                'options' => $scaleOptions,
                'order' => 3
            ],
        ]);
    }
}
