<?php

namespace Database\Seeders;

use App\Enums\UserType;
use App\Models\Lecture;
use App\Models\StudentAnswer;
use App\Models\User;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class StudentAnswerSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $students = User::where('type', UserType::STUDENT->value)->limit(50)->get();
        $lectures = Lecture::with('questions.options')->limit(30)->get();

        foreach ($students as $student) {
            foreach ($lectures as $lecture) {
                if (StudentAnswer::where('lecture_id', $lecture->id)
                        ->where('student_id', $student->id)
                        ->exists()) {
                    continue;
                }

                foreach ($lecture->questions as $question) {
                    $option = null;
                    $isCorrect = null;
                    $answerContent = null;

                    if (in_array($question->question_type->value, [0, 1])) {
                        $option = $question->options->random();
                        $isCorrect = $option->is_correct;
                    } else {
                        $answerContent = fake()->sentence();
                    }

                    StudentAnswer::create([
                        'student_id' => $student->id,
                        'lecture_id' => $lecture->id,
                        'question_id' => $question->id,
                        'question_type' => $question->question_type->value,
                        'answer_content' => $answerContent,
                        'option_id' => $option->id ?? null,
                        'is_correct' => $isCorrect
                    ]);
                }
            }
        }
    }
}
