<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class ArabCountriesSystemSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // 1. Seed Arab Countries
        $this->seedArabCountries();

        // 2. Seed Egyptian Governorates
        $egyptId = $this->seedEgyptianGovernorates();

        // 3. Seed Egyptian Colleges
        if ($egyptId) {
            $this->seedEgyptianColleges($egyptId);
        }
    }

    /**
     * Seed Arab countries data
     */
    protected function seedArabCountries(): void
    {
        if (DB::table('arab_countries')->count() > 0) {
            $this->command->info('Arab countries already seeded. Skipping...');
            return;
        }

        $countries = [
            ['name' => 'Algeria'],
            ['name' => 'Bahrain'],
            ['name' => 'Comoros'],
            ['name' => 'Djibouti'],
            ['name' => 'Egypt'],
            ['name' => 'Iraq'],
            ['name' => 'Jordan'],
            ['name' => 'Kuwait'],
            ['name' => 'Lebanon'],
            ['name' => 'Libya'],
            ['name' => 'Mauritania'],
            ['name' => 'Morocco'],
            ['name' => 'Oman'],
            ['name' => 'Palestine'],
            ['name' => 'Qatar'],
            ['name' => 'Saudi Arabia'],
            ['name' => 'Somalia'],
            ['name' => 'Sudan'],
            ['name' => 'Syria'],
            ['name' => 'Tunisia'],
            ['name' => 'United Arab Emirates'],
            ['name' => 'Yemen'],
        ];

        DB::table('arab_countries')->insert($countries);
        $this->command->info('Seeded 22 Arab countries.');
    }

    /**
     * Seed Egyptian governorates data
     */
    protected function seedEgyptianGovernorates(): ?int
    {
        $egyptId = DB::table('arab_countries')->where('name', 'Egypt')->value('id');

        if (!$egyptId) {
            $this->command->error('Egypt not found in arab_countries table.');
            return null;
        }

        if (DB::table('governorates')->where('arab_countrie_id', $egyptId)->count() > 0) {
            $this->command->info('Egyptian governorates already seeded. Skipping...');
            return $egyptId;
        }

        $governorates = [
            ['arab_countrie_id' => $egyptId, 'name' => 'Cairo'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Alexandria'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Giza'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Dakahlia'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Red Sea'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Beheira'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Fayoum'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Gharbia'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Ismailia'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Menofia'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Minya'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Qaliubiya'],
            ['arab_countrie_id' => $egyptId, 'name' => 'New Valley'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Suez'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Aswan'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Assiut'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Beni Suef'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Port Said'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Damietta'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Sharkia'],
            ['arab_countrie_id' => $egyptId, 'name' => 'South Sinai'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Kafr El Sheikh'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Matrouh'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Luxor'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Qena'],
            ['arab_countrie_id' => $egyptId, 'name' => 'North Sinai'],
            ['arab_countrie_id' => $egyptId, 'name' => 'Sohag'],
        ];

        DB::table('governorates')->insert($governorates);
        $this->command->info('Seeded 27 Egyptian governorates.');

        return $egyptId;
    }

    /**
     * Seed Egyptian colleges data
     */
    protected function seedEgyptianColleges(int $egyptId): void
    {
        if (DB::table('colleges')->count() > 0) {
            $this->command->info('Colleges already seeded. Skipping...');
            return;
        }

        $governorates = DB::table('governorates')
                        ->where('arab_countrie_id', $egyptId)
                        ->select('id', 'name')
                        ->get()
                        ->keyBy('name');

        $colleges = [
            // Cairo Governorate
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Cairo University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Ain Shams University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Al-Azhar University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Helwan University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Misr International University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'German University in Cairo'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'British University in Egypt'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Future University in Egypt'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Modern Sciences and Arts University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Nile University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Ahram Canadian University'],
            ['governorate_id' => $governorates['Cairo']->id, 'name' => 'Canadian International College'],

            // Alexandria Governorate
            ['governorate_id' => $governorates['Alexandria']->id, 'name' => 'Alexandria University'],
            ['governorate_id' => $governorates['Alexandria']->id, 'name' => 'Arab Academy for Science and Technology'],
            ['governorate_id' => $governorates['Alexandria']->id, 'name' => 'Pharos University in Alexandria'],
            ['governorate_id' => $governorates['Alexandria']->id, 'name' => 'Alexandria Higher Institute of Engineering and Technology'],

            // Giza Governorate
            ['governorate_id' => $governorates['Giza']->id, 'name' => 'Cairo University (Giza Branch)'],
            ['governorate_id' => $governorates['Giza']->id, 'name' => 'The American University in Cairo'],
            ['governorate_id' => $governorates['Giza']->id, 'name' => 'Zewail City of Science and Technology'],
            ['governorate_id' => $governorates['Giza']->id, 'name' => 'October University for Modern Sciences and Arts'],
            ['governorate_id' => $governorates['Giza']->id, 'name' => 'Egyptian Russian University'],

            // Assiut Governorate
            ['governorate_id' => $governorates['Assiut']->id, 'name' => 'Assiut University'],
            ['governorate_id' => $governorates['Assiut']->id, 'name' => 'Al-Azhar University (Assiut Branch)'],
            ['governorate_id' => $governorates['Assiut']->id, 'name' => 'Assiut National University'],

            // Sohag Governorate
            ['governorate_id' => $governorates['Sohag']->id, 'name' => 'Sohag University'],
            ['governorate_id' => $governorates['Sohag']->id, 'name' => 'Al-Azhar University (Sohag Branch)'],

            // Aswan Governorate
            ['governorate_id' => $governorates['Aswan']->id, 'name' => 'Aswan University'],

            // Luxor Governorate
            ['governorate_id' => $governorates['Luxor']->id, 'name' => 'Luxor University'],
            ['governorate_id' => $governorates['Luxor']->id, 'name' => 'South Valley University (Luxor Branch)'],

            // South Sinai Governorate
            ['governorate_id' => $governorates['South Sinai']->id, 'name' => 'Suez Canal University (South Sinai Branch)'],

            // North Sinai Governorate
            ['governorate_id' => $governorates['North Sinai']->id, 'name' => 'Sinai University'],

            // Suez Governorate
            ['governorate_id' => $governorates['Suez']->id, 'name' => 'Suez University'],
            ['governorate_id' => $governorates['Suez']->id, 'name' => 'Suez Canal University'],

            // Port Said Governorate
            ['governorate_id' => $governorates['Port Said']->id, 'name' => 'Port Said University'],
            ['governorate_id' => $governorates['Port Said']->id, 'name' => 'Arab Academy for Science and Technology (Port Said Branch)'],

            // Damietta Governorate
            ['governorate_id' => $governorates['Damietta']->id, 'name' => 'Damietta University'],

            // Dakahlia Governorate
            ['governorate_id' => $governorates['Dakahlia']->id, 'name' => 'Mansoura University'],
            ['governorate_id' => $governorates['Dakahlia']->id, 'name' => 'New Mansoura University'],
            ['governorate_id' => $governorates['Dakahlia']->id, 'name' => 'Mansoura National University'],

            // Kafr El Sheikh Governorate
            ['governorate_id' => $governorates['Kafr El Sheikh']->id, 'name' => 'Kafr El Sheikh University'],

            // Gharbia Governorate
            ['governorate_id' => $governorates['Gharbia']->id, 'name' => 'Tanta University'],
            ['governorate_id' => $governorates['Gharbia']->id, 'name' => 'Delta University for Science and Technology'],

            // Menofia Governorate
            ['governorate_id' => $governorates['Menofia']->id, 'name' => 'Menoufia University'],

            // Beheira Governorate
            ['governorate_id' => $governorates['Beheira']->id, 'name' => 'Damanhour University'],
            ['governorate_id' => $governorates['Beheira']->id, 'name' => 'Alexandria University (Damanhour Branch)'],

            // Ismailia Governorate
            ['governorate_id' => $governorates['Ismailia']->id, 'name' => 'Suez Canal University (Ismailia Main Campus)'],

            // Fayoum Governorate
            ['governorate_id' => $governorates['Fayoum']->id, 'name' => 'Fayoum University'],

            // Beni Suef Governorate
            ['governorate_id' => $governorates['Beni Suef']->id, 'name' => 'Beni Suef University'],
            ['governorate_id' => $governorates['Beni Suef']->id, 'name' => 'Al-Azhar University (Beni Suef Branch)'],

            // Minya Governorate
            ['governorate_id' => $governorates['Minya']->id, 'name' => 'Minya University'],
            ['governorate_id' => $governorates['Minya']->id, 'name' => 'Al-Azhar University (Minya Branch)'],

            // Qena Governorate
            ['governorate_id' => $governorates['Qena']->id, 'name' => 'South Valley University'],

            // New Valley Governorate
            ['governorate_id' => $governorates['New Valley']->id, 'name' => 'New Valley University'],

            // Red Sea Governorate
            ['governorate_id' => $governorates['Red Sea']->id, 'name' => 'Suez Canal University (Red Sea Branch)'],

            // Matrouh Governorate
            ['governorate_id' => $governorates['Matrouh']->id, 'name' => 'Matrouh University'],

            // Qaliubiya Governorate
            ['governorate_id' => $governorates['Qaliubiya']->id, 'name' => 'Benha University'],
            ['governorate_id' => $governorates['Qaliubiya']->id, 'name' => 'Higher Technological Institute']
        ];

        DB::table('colleges')->insert($colleges);
        $this->command->info('Seeded '.count($colleges).' Egyptian colleges across all governorates.');
    }
}
