<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('free_materials', function (Blueprint $table) {
            $table->foreignId('subject_id')->nullable()->after('id')->constrained()->onDelete('set null');
            $table->foreignId('course_id')->nullable()->after('subject_id');
        });

        Schema::table('free_materials', function (Blueprint $table) {
            $table->dropColumn('course_ids');
        });
        Schema::table('free_materials', function (Blueprint $table) {
            $table->foreign('course_id')->references('id')->on('courses')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('free_materials', function (Blueprint $table) {
            $table->dropForeign(['subject_id']);
            $table->dropForeign(['course_id']);

            $table->json('course_ids')->nullable()->after('id');

            $table->dropColumn(['subject_id', 'course_id']);
        });
    }
};
