<?php

use App\Enums\PaymentStatus;
use App\Enums\PaymentTypeEnum;
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            $table->foreignId('round_id')->nullable()->constrained()->onDelete('set null');

            $table->integer('payment_type')
                ->default(PaymentTypeEnum::PAYMOB->value);

            $table->decimal('coupon_amount', 10, 2)->nullable();

            $table->foreignId('updated_by')->nullable()->constrained('users');

            // Changing payment_status from boolean to integer
            $table->integer('payment_status')
                ->default(PaymentStatus::PENDING->value)
                ->change();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('course_enrollments', function (Blueprint $table) {
            // Revert back to boolean
            $table->boolean('payment_status')->default(false)->change();

            // Drop only the columns that were added
            $table->dropForeign(['round_id']);
            $table->dropColumn('round_id');

            $table->dropColumn(['payment_type', 'coupon_amount']);

            $table->dropForeign(['created_by']);
            $table->dropForeign(['updated_by']);
            $table->dropColumn(['created_by', 'updated_by']);
        });
    }
};
