<?php

namespace Database\Factories;

use App\Enums\TicketStatus;
use App\Enums\UserType;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class TicketFactory extends Factory
{
    public function definition(): array
    {
        return [
            'description' => $this->faker->sentence(),
            'status' => $this->faker->randomElement(TicketStatus::values()),
            'user_id' => User::where('type', UserType::STUDENT->value)
            ->inRandomOrder()
            ->value('id') 
            ?? User::factory(['type' => UserType::STUDENT->value]),
        ];
    }
}
