<?php

namespace Database\Factories;

use App\Enums\DefineStatus;
use App\Enums\UserType;
use App\Models\Course;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class RoundFactory extends Factory
{
    public function definition(): array
    {
        return [
            'name' => $this->faker->word, 
            'price' => $this->faker->randomFloat(2, 10, 500),
            'whatsapp_group_link' => $this->faker->url,
            'course_id' => Course::inRandomOrder()->value('id') ?? Course::factory(),
            'instructor_id' => User::where('type', UserType::INSTRUCTOR->value)->inRandomOrder()->value('id') 
            ?? User::factory(['type' => UserType::INSTRUCTOR->value]), 
            'status' => $this->faker->randomElement(DefineStatus::values()),
        ];
    }
}
