<?php

namespace Database\Factories;

use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class NotificationFactory extends Factory
{
    public function definition(): array
    {
        $notifiable = User::get()->random();
        return [
            'id'              => fake()->unique()->uuid(),
            'type'            => fake()->randomElement(['notification','message']),
            'notifiable_id'   => $notifiable->id,
            'notifiable_type' => User::class,
            'read_at'         => null,
            'data'            => [
                'message'       => fake()->sentence(),
                'title'         => fake()->sentence(),
                'type'          => fake()->randomElement(['info', 'warning', 'error', 'success']),
                'action'        => fake()->randomElement(['view', 'dismiss']),
                'action_text'   => fake()->sentence(),
                'action_link'   => fake()->url(),
                'action_icon'   => fake()->imageUrl(),
                'action_color'  => fake()->hexColor(),
                'action_type'   => fake()->randomElement(['button', 'link']),
                'action_method' => fake()->randomElement(['get', 'post']),
            ],
        ];
    }
}
