<?php

namespace Database\Factories;

use App\Enums\DefineStatus;
use App\Models\Category;
use Illuminate\Database\Eloquent\Factories\Factory;

class CourseFactory extends Factory
{
    public function definition(): array
    {
        return [
            'title'               => $this->faker->word,
            'description'         => $this->faker->sentence,
            'image'               => $this->faker->imageUrl(640, 480, 'courses', true, 'Main Image'),
            'price'               => $this->faker->randomFloat(2, 10, 500),
            'category_id'         => Category::inRandomOrder()->value('id') ?? Category::factory(),
            'status'              => $this->faker->randomElement(DefineStatus::values()),
            'sessions_count'      => $this->faker->randomNumber(2),
            'duration'            => $this->faker->randomNumber(2),
            'what_you_will_learn' => $this->faker->sentences(3),
            'learning_plan'       => $this->faker->sentences(3),
        ];
    }
}
