<?php

namespace Database\Factories;

use App\Enums\UserType;
use App\Models\Round;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends \Illuminate\Database\Eloquent\Factories\Factory<\App\Models\RoundSupervisor>
 */
class RoundSupervisorFactory extends Factory
{
    /**
     * Define the model's default state.
     *
     * @return array<string, mixed>
     */
    public function definition(): array
    {
        return [
            'round_id' => Round::inRandomOrder()->value('id') ?? Round::factory(),
            'user_id' => User::where('type', UserType::SUPERVISOR->value)
                    ->inRandomOrder()
                    ->value('id') 
                    ?? User::factory(['type' => UserType::SUPERVISOR->value]),
        ];
    }
}
