<?php

return [

      /*
    |--------------------------------------------------------------------------
    | Third Party Services
    |--------------------------------------------------------------------------
    |
    | This file is for storing the credentials for third party services such
    | as Mailgun, Postmark, AWS and more. This file provides the de facto
    | location for this type of information, allowing packages to have
    | a conventional file to locate the various service credentials.
    |
    */

    'postmark' => [
        'token' => env('POSTMARK_TOKEN'),
    ],

    'ses' => [
        'key'    => env('AWS_ACCESS_KEY_ID'),
        'secret' => env('AWS_SECRET_ACCESS_KEY'),
        'region' => env('AWS_DEFAULT_REGION', 'us-east-1'),
    ],

    'resend' => [
        'key' => env('RESEND_KEY'),
    ],

    'slack' => [
        'notifications' => [
            'bot_user_oauth_token' => env('SLACK_BOT_USER_OAUTH_TOKEN'),
            'channel'              => env('SLACK_BOT_USER_DEFAULT_CHANNEL'),
        ],
    ],
    'paymob' => [
            'base_url'        => env('PAYMOB_BASE_URL', 'https://accept.paymob.com'),
            'api_secret_key'  => env('PAYMOB_API_SECRET_KEY'),
            'public_key'      => env('PAYMOB_PUBLIC_KEY'),
            'integration_ids' => [4578744],
            'api_key'         => env('PAYMOB_API_KEY'),
        ],
    'firebase' => [
        'credentials' => storage_path('app/firebase-credentials.json'),
        'database_url' => env('FIREBASE_DB_URL', 'https://eraasoft-2d9c4-default-rtdb.firebaseio.com/'),
    ],

    'zoom'=>[
         'account_id'=>env('ZOOM_ACCOUNT_ID',''),
         'client_id'=>env('ZOOM_CLIENT_ID',''),
         'secret_key'=>env('ZOOM_SECRET_KEY',''),
    ],
    'fawry'=>[
        'merchant_id'=>env('FAWRY_MERCHANT_ID',''),
        'secure_key'=>env('FAWRY_SECURE_KEY',''),
    ]
];
