<?php

namespace App\Services;

use GuzzleHttp\Client;
use Illuminate\Support\Facades\Log;

class WaSenderService
{
    protected $baseUrl;
    protected $appKey;
    protected $authKey;
    protected $templateId;

    public function __construct()
    {
        $this->baseUrl = env('WA_SENDER_SERVICE_URL');
        $this->appKey  = env('WA_SENDER_SERVICE_APP_KEY');
        $this->authKey = env('WA_SENDER_SERVICE_AUTH_KEY');
    }

    public function sendMessage($to, $message)
    {
        try {
            $client = new Client();
            $response = $client->post($this->baseUrl, [
                'form_params' => [
                    'appkey'  => $this->appKey,
                    'authkey' => $this->authKey,
                    'to'      => $to,
                    'message' => $message,
                    'sandbox' => 'true',
                ],
                'curl' => [
                    CURLOPT_SSLVERSION => CURL_SSLVERSION_TLSv1_3,
                ],
            ]);
            return $response;
        } catch (\GuzzleHttp\Exception\RequestException $e) {
            Log::error('WhatsApp message sending failed: ' . $e->getMessage());
            return null;
        } catch (\Exception $e) {
            Log::error('Error sending WhatsApp message: ' . $e->getMessage());
            return null;
        }
    }
}
