<?php

namespace App\Services\Payment;

class PaymentTransactionService extends BasePaymentService
{
    protected string $secretKey;
    protected array $integrationIds;
    protected string $baseUrl;
    protected array $headers;
    protected string $currency;
    protected string $apiKey;
    public function __construct()
    {
        $this->baseUrl        = config('services.paymob.base_url');
        $this->secretKey      = config('services.paymob.api_secret_key');
        $this->integrationIds = config('services.paymob.integration_ids');
        $this->apiKey      = config('services.paymob.api_key');
        $this->currency       = "EGP";
        $this->headers        = [
            'Accept'        => 'application/json',
            'Content-Type'  => 'application/json',
            // 'Authorization' => 'Token ' . $this->secretKey,
        ];
    }
public function getTransaction()
{
    $url = '/api/ecommerce/orders';
    $token = $this->getAuthToken();
    $this->headers['Authorization'] = 'Bearer ' . $token;

    $allResults = []; // To store all transactions
    $nextUrl = $this->baseUrl . $url; // Start with the initial URL

    do {
        // Fetch data from the current URL
        $response = $this->buildRequest('GET', $nextUrl, $this->headers, null, 'json');
        
        // Check if the response is valid and has data
        $responseData = $response->getData();

        // Debugging: Log or print the response to check its structure
        // This can help you understand if there are any issues with the API response format.
        // print_r($responseData);
        // Or use a logger if you have one
        // \Log::info($responseData);

        // Check if the response contains the expected data
        if (isset($responseData->data) && isset($responseData->data->result)) {
            if (!empty($responseData->data->result)) {
                $allResults = array_merge($allResults, $responseData->data->result);
            }
        } else {
            // Handle cases where the data structure is different or empty
            // This can help you debug and adjust accordingly
            \Log::warning("Unexpected response structure", (array)$responseData);
        }

        // Get the next page URL
        $nextUrl = $responseData->data->next ?? null;

    } while ($nextUrl); // Continue until there are no more pages

    return $allResults; // Return all transactions
}

}