<?php

namespace App\Services\Payment;

use GuzzleHttp\Client;

class CurrencyConverter
{
    protected $client;
    protected $apiUrl;

    public function __construct()
    {
        $this->client = new Client();
        $this->apiUrl = "https://latest.currency-api.pages.dev/v1/currencies/usd.json"; // API URL
    }

/**
 * Convert currency from USD to EGP.
 *
 * @param float $amount
 * @param string $from
 * @param string $to
 * @return int
 */
public function convert($amount, $from = 'USD', $to = 'EGP')
{
    // Fetch exchange rates
    $rate = $this->getExchangeRate($to);

    if ($rate == 0) {
        throw new \Exception("Failed to fetch exchange rate for {$to}.");
    }

    // Perform conversion and ensure it's a valid integer
    $convertedAmount = $amount * $rate;

    return (int)floor($convertedAmount); // Always rounds down to the nearest integer
}


    /**
     * Get exchange rate for a specific currency.
     *
     * @param string $currency
     * @return float
     */
    private function getExchangeRate($currency)
    {
        try {
            $response = $this->client->get($this->apiUrl);
            $data = json_decode($response->getBody()->getContents(), true);

            // Check if the requested currency exists
            if (isset($data['usd'][strtolower($currency)])) {
                return $data['usd'][strtolower($currency)];
            }

            return 0;
        } catch (\Exception $e) {
            throw new \Exception("Error fetching exchange rate: " . $e->getMessage());
        }
    }
}
