<?php

namespace App\Services\Payment;

use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Response;
use App\Interfaces\PaymentGatewayInterface;

class ApplyPaymentService
{

    public function __construct(protected PaymentGatewayInterface $paymentGateway){}

    public function initiatePayment(array $paymentDetails)
    {
        try {
            $paymentData = $this->preparePaymentData($paymentDetails);
            $response    = $this->paymentGateway->sendPayment($paymentData);
            return $this->handlePaymentResponse($response);
        } catch (\Exception $e) {
            \Log::error('Payment error: ' . $e->getMessage());
            return Response::json([
                'success' => false,
                'message' => 'An error occurred while processing the payment: ' . $e->getMessage(),
            ], 500);
        }


    }
    private function preparePaymentData(array $paymentDetails): array
    {
        $amount = $paymentDetails['amount'];
        return [
            "amount" => $amount * 100,
            "items"  => [
                [
                    "name"        => $paymentDetails['title'],
                    "amount"      => $amount * 100,
                    "description" => $paymentDetails['description'],
                    "quantity"    => 1,
                    'image'       => $paymentDetails['image']??null
                ]
            ],

            "billing_data" => [
                "apartment"    => "NA",
                "first_name"   => Auth::user()->first_name ?? 'NA',
                "last_name"    => Auth::user()->last_name && !empty(trim(Auth::user()->last_name)) ? Auth::user()->last_name : 'NA',
                "phone_number" => 'NA',
                "email"        => Auth::user()->email ?? 'NA',
                "country"      => 'EG',
                "street"       => "NA",
                "building"     => "NA",
                "city"         => "NA",
                "floor"        => "NA",
                "state"        => "NA"
            ]
        ];
    }

    private function handlePaymentResponse(array $response)
    {
        return Response::json([
            'success' => $response['success'],
            'message' => $response['success']
                                ? 'Payment processed successfully.' 
                                :   ($response['message'] ?? 'Payment failed.'),
            'redirect_url' => $response['redirect_url'] ?? null,
            'data'         => $response['data'] ?? null
        ], $response['success'] ? 200 : 400);
    }
}
