<?php

namespace App\Providers;

use App\Enums\UserType;
use App\Models\User;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\ServiceProvider;

class RouteModelBindingProvider extends ServiceProvider
{
    /**
     * Register services.
     */
    public function register(): void
    {
        //
    }

    /**
     * Bootstrap services.
     */
    public function boot(): void
    {
        Route::bind('instructor', function ($value) {
            return User::where('type', UserType::INSTRUCTOR->value)
                ->where('id', $value)
                ->firstOrFail();
        });
    
        Route::bind('supervisor', function ($value) {
            return User::where('type', UserType::SUPERVISOR->value)
                ->where('id', $value)
                ->firstOrFail();
        });
    
        Route::bind('student', function ($value) {
            return User::where('type', UserType::STUDENT->value)
                ->where('id', $value)
                ->firstOrFail();
        });
    
        Route::bind('admin', function ($value) {
            return User::where('type', UserType::ADMIN->value)
                ->where('id', $value)
                ->firstOrFail();
        });
    }
}
