<?php

namespace App\Providers;

use App\Models\Evaluation;
use Dedoc\Scramble\Scramble;
use App\Models\TaskSubmission;
use App\Observers\EvaluationObserver;
use Essa\APIToolKit\Exceptions\Handler;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\ServiceProvider;
use App\Observers\TaskSubmissionObserver;
use App\Interfaces\PaymentGatewayInterface;
use Dedoc\Scramble\Support\Generator\OpenApi;
use App\Services\Payment\PaymobPaymentService;
use Illuminate\Contracts\Debug\ExceptionHandler;
use Dedoc\Scramble\Support\Generator\SecurityScheme;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        if ($this->app->environment('local') && class_exists(\Laravel\Telescope\TelescopeServiceProvider::class)) {
            $this->app->register(\Laravel\Telescope\TelescopeServiceProvider::class);
            $this->app->register(TelescopeServiceProvider::class);

        }
        $this->app->bind(ExceptionHandler::class, Handler::class);
        $this->app->bind(PaymentGatewayInterface::class, PaymobPaymentService::class);
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        Model::preventLazyLoading(! app()->isProduction());
        TaskSubmission::observe(TaskSubmissionObserver::class);
        Evaluation::observe(EvaluationObserver::class);
        Scramble::configure()
        ->withDocumentTransformers(function (OpenApi $openApi) {
            $openApi->secure(
                SecurityScheme::http('bearer')
            );
        });
    }
}
