<?php

namespace App\Observers;

use App\Models\Evaluation;
use Illuminate\Support\Facades\Cache;

class EvaluationObserver
{
    /**
     * Handle the Evaluation "created" event.
     */
    public function created(Evaluation $evaluation): void
    {
        $this->clearStudentProgressCache($evaluation->user_id);
    }

    /**
     * Handle the Evaluation "updated" event.
     */
    public function updated(Evaluation $evaluation): void
    {
        $this->clearStudentProgressCache($evaluation->user_id);
    }

    /**
     * Handle the Evaluation "deleted" event.
     */
    public function deleted(Evaluation $evaluation): void
    {
        $this->clearStudentProgressCache($evaluation->user_id);
    }

    /**
     * Handle the Evaluation "restored" event.
     */
    public function restored(Evaluation $evaluation): void
    {
        //
    }

    /**
     * Handle the Evaluation "force deleted" event.
     */
    public function forceDeleted(Evaluation $evaluation): void
    {
        //
    }

    /**
     * Clear the student progress cache.
     */
    private function clearStudentProgressCache(int $userId): void
    {
        $cacheKey = "student_progress_{$userId}";
        Cache::forget($cacheKey);
    }
}
