<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;


class ZoomMeeting extends Model
{
    /**
     * Mass-assignable attributes.
     *
     * @var array
     */
    protected $fillable = [
        'ref_id',
        'topic',
        'start_time',
        'duration',
        'join_url',
        'start_url',
        'agenda',
        'lecture_id',
    ];

    /**
     * Relationship with lecture
     * The meeting is belongs to a lecture
     */
    public function lecture(): BelongsTo
    {
        return $this->belongsTo(Lecture::class);
    }
}
