<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Topic extends Model implements Sortable
{
    use SortableTrait;
    protected $fillable = [
        'name',
        'order',
    ];
    public $sortable = [
        'order_column_name' => 'order',
        'sort_when_creating' => true,
    ];
    public function courses()
    {
        return $this->hasMany(Course::class,'topic_id');
    }
}
