<?php

namespace App\Models;

use App\Enums\TicketType;
use App\Filters\TicketMessageFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Support\Facades\Storage;


class TicketMessage extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = TicketMessageFilters::class;

    /**
     * Mass-assignable attributes.
     *
     * @var array
     */
    protected $fillable = [
        'content',
        'ticket_id',
        'created_by',
        'type',
    ];

    /**
     * Relationship with ticket
     * each ticket message belongs to a ticket
     */
    public function ticket(): BelongsTo
    {
        return $this->belongsTo(Ticket::class);
    }

    public function getContentAttribute($value)
    {
        if($this->type === TicketType::AUDIO->value){
            return asset(Storage::url($value));
        }

        return $value;
    }
}
