<?php

namespace App\Models;

use App\Enums\TicketStatus;
use App\Filters\TicketFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\HasMany;


class Ticket extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = TicketFilters::class;

    protected $casts = [
        'status' => TicketStatus::class,
        // 'type' => TicketStatus::class,
    ];

    /**
     * Mass-assignable attributes.
     *
     * @var array
     */
    protected $fillable = [
        'user_id',
        'admin_id',
        'description',
        'status',
    ];

    /**
     * Relationship with user (as student)
     * each ticket belongs to a user
     */
    public function student(): BelongsTo
    {
        return $this->belongsTo(User::class, 'user_id');
    }

    /**
     * Relationship with ticket messages
     * each ticket can have many ticket messages
     */
    public function messages(): HasMany
    {
        return $this->hasMany(TicketMessage::class);
    }

    public function admin(): BelongsTo
    {
        return $this->belongsTo(User::class, 'admin_id');
    }
}
