<?php

namespace App\Models;

use App\Filters\GradeFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;

class StudentGrade extends Model
{
    use Filterable;
    protected string $default_filters = GradeFilters::class;
     protected $fillable = [
        'student_id',
        'lecture_id',
        'total_questions',
        'correct_answers',
        'grade'
    ];

    public function student()
    {
        return $this->belongsTo(User::class);
    }

    public function lecture()
    {
        return $this->belongsTo(Lecture::class);
    }
}
