<?php

namespace App\Models;

use App\Enums\QuestionType;
use App\Filters\QuestionFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;

class Question extends Model
{
    use Filterable;
    protected string $default_filters = QuestionFilters::class;
    protected $fillable = [
        'category_id',
        'question_type',
        'question_content',
        'tag_id',
        'listening_content',
        'answer_writing',
        'case'
    ];
    protected $casts = [
        'question_type' => QuestionType::class,
    ];

    public function tag(){
        return $this->belongsTo(PlacementTestTag::class,'tag_id');
    }
    // public function case()
    // {
    //     return $this->belongsTo(LectureQuestionCase::class);
    // }

    public function category()
    {
        return $this->belongsTo(Category::class);
    }

    public function options()
    {
        return $this->hasMany(BankOption::class);
    }
    public function getUrlAttribute()
    {
        if($this->attributes['question_type'] == QuestionType::Listening->value){
            return asset(Storage::url($this->attributes['listening_content']));
        }
        return $this->attributes['listening_content'];
    }
}
