<?php

namespace App\Models;

use App\Filters\PlacementTestResultFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;

class PlacementTestResult extends Model
{
    use Filterable;
    protected string $default_filters = PlacementTestResultFilters::class;
    protected $fillable = [
        'user_id',
        'total_questions',
        'total_correct_answers',
        'max_level_id',
        'percentage',
        'levels'
    ];

    protected $casts = [
        'levels' => 'array',
    ];

    public function level(){
        return $this->belongsTo(Category::class,'max_level_id');
    }
    public function user(){
        return $this->belongsTo(User::class);
    }
}
