<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Str;

class Notification extends Model
{
    use HasFactory;
    protected $fillable = [
        'id',
        'type',
        'notifiable_id',
        'notifiable_type',
        'read_at',
        'data'
    ];
    protected $casts = [
        'data' => 'array',
    ];

    public function scopeUnread($query)
    {
        return $query->whereNull('read_at');
    }
    public function markAsRead()
    {
        $this->update(['read_at' => now()]);
    }
    public function notifiable()
    {
        return $this->morphTo();
    }
    // In your Notification model
public $incrementing = false;
protected $keyType = 'string';

protected static function boot()
{
    parent::boot();

    static::creating(function ($model) {
        $model->id = Str::uuid()->toString();
    });
}
}
