<?php

namespace App\Models;

use App\Filters\LectureTaskFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class LectureTask extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = LectureTaskFilters::class;

    // protected $casts = [
    //     'files_included' => 'array',
    // ];

    protected $appends = [
        'first_file',
    ];

    protected $fillable = [
        'lecture_id',
        'description',
        'goal',
        'note',
        'files_included',
        'deadline',
        'task_link'
    ];
    public function getFirstFileAttribute(): ?string
    {
        $first = $this->files_included ?? null;

        return isset($first) ? asset('storage/' . $first) : null;
    }



}
