<?php

namespace App\Models;

use App\Enums\QuestionType;
use App\Enums\QuestionCategory;
use App\Filters\LectureQuestionFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Storage;
use Illuminate\Database\Eloquent\Factories\HasFactory;


class LectureQuestion extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = LectureQuestionFilters::class;

    protected $casts = [
        // 'category'      => QuestionCategory::class,
        'question_type' => QuestionType::class,
    ];
    protected $fillable = [
        'lecture_id',
        'category',
        'question_type',
        'question_content',
        'case_id',
        'tag_id',
        'listening_content',
        'answer_writing',
    ];
    public function tag(){
        return $this->belongsTo(PlacementTestTag::class,'tag_id');
    }


    public function getQuestionContentAttribute()
    {
        if($this->attributes['question_type'] == QuestionType::Listening->value){
            return asset(Storage::url($this->attributes['listening_content']));
        }
        return $this->attributes['listening_content'];
    }

    public function getQuestionContentPathAttribute()
    {
        return $this->attributes['listening_content'];
    }

    public function getQuestionContent()
    {
        return $this->attributes['question_content'];
    }


    public function options()
    {
        return $this->hasMany(QuestionOption::class,'lecture_question_id');
    }

    public function lecture(){
        return $this->belongsTo(Lecture::class);
    }
    public function case()
    {
        return $this->belongsTo(LectureQuestionCase::class);
    }

    public function getUrlAttribute()
    {
        if($this->attributes['question_type'] == QuestionType::Listening->value){
            return asset(Storage::url($this->attributes['listening_content']));
        }
        return $this->attributes['listening_content'];
    }
}
