<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;
class FreeMaterial extends Model
{
    use HasFactory;
    protected $fillable = ['type', 'title', 'link', 'course_id', 'subject_id'];
    protected $appends = ['link_url'];


    public function course()
    {
        return $this->belongsTo(Course::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }
    public function getLinkUrlAttribute(): string
    {
        return $this->type === 'pdf'
            ? asset('storage/' . $this->link)
            : $this->link;
    }
    public function getCoursesAttribute()
    {
        return $this->course ? collect([$this->course]) : collect([]);
    }

}
