<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Expense extends Model
{
    protected $fillable = [
        'expense_category_id',
        'bio',
        'cost',
        'accepted_by',
        'created_by',
        'updated_by',
        'morphable_id',
        'morphable_type',
        'payment_method_id'
    ];

    protected static function booted()
    {
        static::creating(function ($model) {
            $model->created_by = $model->created_by ?? auth()->id();

            if ($model->morphable_type !== null && !str_starts_with($model->morphable_type, 'App\\Models\\')) {
                $model->morphable_type = 'App\\Models\\' . ucfirst($model->morphable_type);
            }

            PaymentMethod::where('id', $model->payment_method_id)
            ->decrement('total_amount', $model->cost);
        });

        static::updating(function ($model) {
            $model->updated_by = auth()->id();

            if ($model->morphable_type !== null && !str_starts_with($model->morphable_type, 'App\\Models\\')) {
                $model->morphable_type = 'App\\Models\\' . ucfirst($model->morphable_type);
            }
        });
    }


    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }
    public function updatedBy()
    {
        return $this->belongsTo(User::class, 'updated_by');
    }

    public function expenseCategory()
    {
        return $this->belongsTo(ExpenseCategory::class, 'expense_category_id');
    }

    public function morphable()
    {
        return $this->morphTo();
    }

    public function paymentMethod()
    {
        return $this->belongsTo(PaymentMethod::class, 'payment_method_id');
    }

    public function acceptedBy()
    {
        return $this->belongsTo(User::class, 'accepted_by');
    }


}
