<?php

namespace App\Models;

use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Model;
use App\Filters\CourseEnrollmentFilters;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Support\Facades\Auth;

class CourseEnrollment extends Model
{
    use HasFactory , Filterable;
    protected string $default_filters = CourseEnrollmentFilters::class;
    protected $fillable = [
        'course_id',
        'user_id',
        'total_amount',
        'enrollment_date',
        'status',
        'payment_method',
        'payment_status',
        'transaction_id',
        'coupon_id',
        'created_by',
        'round_id',
        'payment_type',
        'coupon_amount',
        'updated_by',
        'fawry_ref',
        'paid',
        'fawry_response',
    ];


    public static function boot()
    {
        parent::boot();

        static::creating(function ($model) {
            if (Auth::check()) {
                $model->created_by = $model->created_by ?? Auth::id();
            }
        });

        static::updating(function ($model) {
            if (Auth::check()) {
                $model->updated_by = Auth::id();
            }
        });
    }

    public function course()
    {
        return $this->belongsTo(Course::class, 'course_id', 'id');
    }

    public function user()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function coupon()
    {
        return $this->belongsTo(Coupon::class);
    }

    public static function isUserEnrolled($userId, $courseId)
    {
        return self::where('user_id', $userId)
            ->where('course_id', $courseId)
            ->where('status', true)
            ->where('payment_status', true)
            ->exists();
    }

    public function scopeForAuthUser($query)
    {
        return $query->where('user_id', Auth::id());
    }

    public function scopeNotAddedToGroup($query)
    {
        $course        = $this->course;
        $roundsIds     = Round::where('course_id', $course->id)->pluck('id');
        $isUserInGroup = RoundStudent::where('user_id', $this->attributes['user_id'])
            ->whereIn('round_id', $roundsIds)
            ->exists();
        if ($isUserInGroup) {
            return $query->where('user_id', '!=', $this->attributes['user_id']);
        }
        return $query;
    }
    public function installments(){
        return $this->hasMany(Installment::class,'course_enrollment_id','id');
    }
    public function transactions(){
        return $this->hasMany(Transaction::class,'course_enrollment_id','id');
    }
    public function round()
    {
        return $this->belongsTo(Round::class, 'round_id', 'id');
    }
}
