<?php

namespace App\Models;

use App\Enums\TypeCoupon;
use App\Filters\CouponFilters;
use Essa\APIToolKit\Filters\Filterable;
use GPBMetadata\Google\Protobuf\Type;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;


class Coupon extends Model
{
    use HasFactory, Filterable;

    protected string $default_filters = CouponFilters::class;

    /**
     * Mass-assignable attributes.
     *
     * @var array
     */
    protected $fillable = [
        'code',
        'discount_percentage',
        'max_uses',
        'uses',
        'start_date',
        'end_date',
        'status',
        'type'
    ];

    protected $casts = [
        'type'=>TypeCoupon::class,
    ];

    public function scopeActive($query)
    {
        return $query->where('status', true);
    }

    public function scopeExpired($query)
    {
        return $query->where('end_date', '<', now());
    }

    public function scopeNotExpired($query)
    {
        return $query->where('end_date', '>', now());
    }

    public function scopeNotUsed($query)
    {
        return $query->where('uses', '<', $this->max_uses);
    }

}
