<?php

namespace App\Models;

use App\Filters\CategoryFilters;
use Essa\APIToolKit\Filters\Filterable;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Spatie\EloquentSortable\Sortable;
use Spatie\EloquentSortable\SortableTrait;

class Category extends Model implements Sortable
{
    use HasFactory,Filterable, SortableTrait;

    protected string $default_filters = CategoryFilters::class;

    protected $fillable = [
        'name',
        'status',
        'order'
    ];
    public $sortable = [
        'order_column_name' => 'order',
        'sort_when_creating' => true,
    ];

    /**
     * Relationship with courses
     * (the category can have many courses)
     */
    public function courses(): HasMany
    {
        return $this->hasMany(Course::class);
    }
    public function questions(){
        return $this->hasMany(Question::class);
    }
    public function placementTestResults(){
        return $this->hasMany(PlacementTestResult::class,'max_level_id');
    }
}
