<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\Facades\Auth;
use App\Models\User;
use App\Filters\ActivityLogFilters;
use Essa\APIToolKit\Filters\Filterable;

class ActivityLog extends Model
{
    use Filterable;
    protected string $default_filters = ActivityLogFilters::class;
    protected $fillable = [
        'user_id',
        'action',
        'message',
        'context',
        'ip_address',
        'user_agent',
    ];

    protected $casts = [
        'context' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public static function log(string $action, string $message, ?array $context = [], ?User $user = null): void
    {
        $user = $user ?: (Auth::check() ? Auth::user() : null);

        static::create([
            'user_id' => $user ? $user->id : null,
            'action' => $action,
            'message' => $message,
            'context' => $context,
            'ip_address' => Request::ip(),
            'user_agent' => Request::userAgent(),
        ]);
    }
}
