<?php

namespace App\Imports;

use App\Enums\DefineStatus;
use App\Enums\PaymentMethodEnum;
use App\Enums\PaymentStatus;
use App\Enums\UserType;
use App\Models\CourseEnrollment;
use App\Models\Payment;
use App\Models\Round;
use App\Models\RoundStudent;
use App\Models\User;
use Illuminate\Support\Facades\Auth;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
use Illuminate\Support\Facades\Hash;


class UsersImport implements ToModel, WithHeadingRow
{
    private $round_id;
    private $invalidRows = [];

    public function setRoundId($round_id)
    {
        $this->round_id = $round_id;
    }

    public function getInvalidRows()
    {
        return $this->invalidRows;
    }


    public function model(array $row)
    {

        if (empty($row['name']) || empty($row['email']) || empty($row['phone'])) {
            $this->invalidRows[]=$row;
            return null;
        }

        $newRound = Round::with('course')->findOrFail($this->round_id);

        $user = User::firstOrCreate(
            ['phone' => $row['phone'],'email'=> $row['email']],
            [
                'name'  => $row['name'],
                'email' => $row['email'],
                'phone' => $row['phone'],
                'password'=>Hash::make('123123123'),
                'type'  => UserType::STUDENT->value,
            ]
        );

        $roundStudent = RoundStudent::where('round_id', $newRound->id)
                                    ->where('user_id', $user->id)
                                    ->first();

        if (!$roundStudent) {
            $amount = $newRound->price ?? $newRound->course->price;
            CourseEnrollment::create([
                'course_id'       => $newRound->course_id,
                'user_id'         => $user->id,
                'total_amount'    => $amount,
                'enrollment_date' => now(),
                'status'          => true,
                'payment_method'  => PaymentMethodEnum::CASH->value ,
                'payment_status'  => PaymentStatus::PENDING->value,
                'transaction_id'  => null,
                'coupon_id'       => null,
                'created_by'      => Auth::id() ?? 1,
                'updated_by'      => Auth::id() ?? 1,
                'round_id'        => $newRound->id,
                'payment_type'    => 0,
                'coupon_amount'   => 0,
            ]);
            RoundStudent::create([
                'round_id'        => $newRound->id,
                'user_id'         => $user->id,
                'total_amount'    => $amount,
                'enrollment_date' => now(),
                'status'          => DefineStatus::ACTIVE->value,
                'payment_method'  => 'cache',
                'payment_status'  => '1',
                'transaction_id'  => null
            ]);
        }
    }
}
