<?php 
namespace App\Http\Traits;

use Illuminate\Support\Facades\Storage;

trait MediaHandler{
    public static function upload($fileValidated,$path)
    {
        $vidName = rand(1,100000). now()->format('YmdHis') .$fileValidated->getClientOriginalName();
        return $fileValidated->storeAs($path, $vidName, 'public');
    }
    public static function updateMedia($media,$path,$storagePath=null,$disk='public')
    {
        if ($storagePath && Storage::disk($disk)->exists($storagePath)) {
            Storage::disk($disk)->delete($storagePath);
        }
        // $storagePath='public/'.$storagePath;
        // if(Storage::exists($storagePath)){
        //     Storage::delete($storagePath);
        // }
        return self::upload($media, $path);
    }
    public static function deleteMedia($storagePath,$disk='public')
    {
        // $storagePath='public/'.$storagePath;
        // if(Storage::exists($storagePath)){
        //     Storage::delete($storagePath);
        // }
        if (Storage::disk($disk)->exists($storagePath)) {
            Storage::disk($disk)->delete($storagePath);
        }
    }
    public static function deleteArrayOfMedia(array $storagePaths)
    {
        foreach($storagePaths as $storagePath){
            $storagePath='public/'.$storagePath;
            if(Storage::exists($storagePath)){
                Storage::delete($storagePath);
            }
        }
    }
}