<?php

namespace App\Http\Resources\TicketSystem;

use App\Enums\UserType;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TicketSystemResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'subject'=>$this->subject,
            'description'=>$this->description,
            'status'=>$this->status,
            'priority'=>$this->priority,
            'open_date'=>$this->open_date ? $this->open_date->format('Y-m-d H:i:s') : null,
            'close_date'=>$this->close_date ? $this->close_date->format('Y-m-d H:i:s') : null,
            'diff_open_close'=>$this->open_date && $this->close_date ? $this->open_date->diffInHours($this->close_date) : null,
            'user'=>$this->whenLoaded('user',function(){
                return $this->user->name;
            }),
            'assigned_to'=>$this->whenLoaded('assignedTo',function(){
                return [
                    'name'=>$this->assignedTo->name,
                    'id'=>$this->assignedTo->id,
                    'type'=>UserType::from($this->assignedTo->type)->value,
                ];
            }),
            'assigned_to_by'=>$this->whenLoaded('assignedToBy',function(){
                return $this->assignedToBy->name;
            }),
            'ticket_replies'=>TicketRepliesResource::collection($this->whenLoaded('ticketReplies')),
            'ticket_attachments'=>$this->whenLoaded('ticketAttachments',function(){
                return $this->ticketAttachments->map(function($ticketAttachment){
                    return [
                        'id'=>$ticketAttachment->id,
                        'file_path' => $ticketAttachment->file_path,
                    ];
            });
            })
        ];
    }
}
