<?php

namespace App\Http\Resources\TicketSystem;

use App\Enums\UserType;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class TicketRepliesResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'ticket_id'=>$this->ticket_id,
            'user'=>$this->whenLoaded('user',function(){
                return [
                    'id'=>$this->user->id,
                    'name'=>$this->user->name,
                    'type' => $this->user->type ? UserType::userType(UserType::from($this->user->type)) : null,
                ];
            }),
            'message'=>$this->message
        ];
    }
}
