<?php

namespace App\Http\Resources\TicketMessage;

use App\Http\Traits\ResourceHelper;
use Illuminate\Http\Resources\Json\JsonResource;

class TicketMessageResource extends JsonResource
{
    use ResourceHelper;

    public function toArray($request): array
    {
        $currentUserId = auth()->id();
        $isSender = $this->created_by === $currentUserId;

        return [
            'id'         => $this->id,
            'content'    => $this->content,
            'type'       => $this->type,
            'is_sender'  => $isSender, 
            'created_at' => $this->whenExists($this->created_at ?? dateTimeFormat($this->created_at)),
        ];
    }
}
