<?php

namespace App\Http\Resources\Ticket;

use App\Http\Resources\TicketMessage\TicketMessageResource;
use App\Http\Resources\User\UserResource;
use App\Http\Traits\ResourceHelper;
use Illuminate\Http\Resources\Json\JsonResource;

class TicketResource extends JsonResource
{
    use ResourceHelper;


    public function toArray($request): array
    {
        return [
            'id'          => $this->id,
            'description' => $this->description,
            'status'      => $this->status,
            'student'     => new UserResource($this->whenLoaded('student')),
            'content'     => TicketMessageResource::collection($this->whenLoaded('messages')),
            'created_at'  => $this->whenExists($this->created_at?->format('Y-m-d')),
        ];
    }
}
