<?php

namespace App\Http\Resources\TaskSubmission;

use Illuminate\Http\Request;
use App\Http\Traits\ResourceHelper;
use App\Http\Resources\User\UserResource;
use App\Http\Resources\Lecture\LectureResource;
use App\Http\Resources\Round\RoundResource;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\TaskFeedback\TaskFeedbackResource;

class TaskSubmissionResource extends JsonResource
{
    use ResourceHelper;

    public function toArray(Request $request): array
    {
        return [
            'id'           => $this->id,
            'task_url'     => $this->task_url,
            'task_degree'  => $this->whenExists($this->task_degree),
            'is_corrected' => $this->whenExists($this->is_corrected),
            'graded_by'    => new UserResource($this->whenLoaded('gradedBy')),
            'user'         => new UserResource($this->whenLoaded('user')),
            'lecture'      => new LectureResource($this->whenLoaded('lecture')),
            'feedbacks'    => TaskFeedbackResource::collection($this->whenLoaded('feedbacks')),
        ];
    }
}
