<?php

namespace App\Http\Resources;

use App\Http\Resources\User\UserResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class SurveyAnswerResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'user_id' => new UserResource($this->whenLoaded('user')),
            'survey_id' => $this->survey_id,
            'section_id' => new SurveySectionResource($this->whenLoaded('section')),
            'question_id' => new SurveyQuestionResource($this->whenLoaded('question')),
            'answer' => $this->answer,
            'question_type' => $this->question_type,
            'request_ip' => $this->request_ip,
            'created_at' => $this->created_at,
            'updated_at' => $this->updated_at,
        ];
    }
}
