<?php

namespace App\Http\Resources\Round;

use App\Enums\UserType;
use App\Http\Resources\Branche\BrancheResource;
use App\Http\Resources\Course\CourseResource;
use App\Http\Resources\Lecture\LectureResource;
use App\Http\Resources\Notice\NoticeResource;
use App\Http\Resources\User\UserResource;
use \App\Http\Traits\ResourceHelper;
use Illuminate\Http\Resources\Json\JsonResource;

class RoundResource extends JsonResource
{
    use ResourceHelper;

    public function toArray($request): array
    {
        return [
            'id'                  => $this->id,
            'name'                => $this->name,
            'price'               => $this->price,
            'discount'            => $this->discount,
            'task_submissions_is_corrected'=>$this->taskSubmissionsDegreeSummary(),
            'absence'=>$this->getAbsence($this->id),
            'coupon_amount' => $this->whenLoaded('myCourseEnrollment', function () {
                return $this->myCourseEnrollment->coupon_amount;
            }),
            'whatsapp_group_link' => $this->whatsapp_group_link,
            'google_meet_link'    => $this->google_meet_link,
            'max_students'        => $this->max_students,
            'status'              => $this->status,
            'type'                => $this->type,
            'start_date'          => $this->start_date?->format('Y-m-d'),
            'end_date'            => $this->end_date?->format('Y-m-d'),
            'max_student'         =>$this->max_student,
            'link_url'            =>$this->link_url,
            'weeks_count'         =>$this->weeks_count,
            'days_count'          =>$this->days_count,
            'day_one'             =>$this->day_one,
            'day_two'             =>$this->day_two,
            'attendance_rate' => auth()->user()->type == UserType::INSTRUCTOR->value
                ? $this->getAttendanceRate()
                : $this->getAttendanceRateByUser(),

            'task_submission_rate' => auth()->user()->type == UserType::INSTRUCTOR->value
                ? $this->getTaskSubmissionRate()
                : $this->getTaskSubmissionRateByUser(),
            'average_rating' => null,
            'additional_instructors'=>$this->additional_instructors,
            'round_content'=>$this->round_content,
            'notices'           =>NoticeResource::collection($this->whenLoaded('notices')),
            'branch'            => $this->whenLoaded('branch',function(){
                return new BrancheResource($this->branch);
            }),
            'is_running'          => $this->isRunning(),
            'has_ended'           => $this->hasEnded(),
            'has_not_started'     => $this->hasNotStarted(),
            'student_ids' => $this->whenLoaded('students', function() {
                return $this->students->pluck('id');
            }, []),
            'instructor'          => new UserResource($this->whenLoaded('instructor')),
            'course'              => new CourseResource($this->whenLoaded('course')),
            'lectures_count' => $this->whenLoaded('lectures', fn() => $this->lectures->count()),
            'weeks_count' => $this->whenLoaded('lectures', fn() => $this->lectures->groupBy('week_number')->count()),
            'lectures' => $this->whenLoaded('lectures', function () {
                if ($this->lectures->isEmpty()) {
                    return null;
                }
                return $this->lectures->load('attachments')
                    ->groupBy('week_number')
                    ->mapWithKeys(fn ($items, $week) => [
                        'Week '.$week => LectureResource::collection($items)
                    ]);
            }),
            'installments'=>$this->whenLoaded('installments',function(){
                $this->installments->count();
            }),
            'transactions'=>$this->whenLoaded('transactions',function(){
                $this->transactions->count();
            })
        ];
    }
}
