<?php

namespace App\Http\Resources\Review;

use App\Http\Resources\Lecture\LectureResource;
use App\Http\Resources\User\UserResource;
use Illuminate\Http\Resources\Json\JsonResource;

class ReviewResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'=>$this->id,
            'user_id'=>new UserResource($this->user),
            'lecture_id'=>new LectureResource($this->lecture),
            'rating'=>$this->rating,
            'comment'=>$this->comment,
        ];
    }
}
