<?php

namespace App\Http\Resources\PlacementTestClientSide;

use App\Http\Resources\User\UserResource;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class PlacementTestResultResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'user'=>new UserResource($this->whenLoaded('user')),
            'id'=>$this->id,
            'total_questions'=>$this->total_questions,
            'total_correct_answers'=>$this->total_correct_answers,
            'max_level'=>new CategoryResource($this->whenLoaded('level')),
            'percentage'=>$this->percentage,
            'levels'=>$this->levels,
        ];
    }
}
