<?php

namespace App\Http\Resources\PaymentMethod;

use App\Http\Resources\Transaction\TransactionResource;
use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class PaymentMethodResources extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id' => $this->id,
            'name' => $this->name,
            'sum_amount' => $this->sum_amount,
            'sub_amount' => $this->sub_amount,
            'total_amount' => $this->total_amount,
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'transactions' => $this->whenLoaded('transactions', function () {
                return TransactionResource::collection($this->transactions);
            }),
        ];
    }
}
