<?php

namespace App\Http\Resources\Notification;

use Carbon\Carbon;
use Illuminate\Http\Resources\Json\JsonResource;

class NotificationResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'      => $this->id,
            'title'   => $this->data['title'] ?? null,
            'content' => $this->data['content'] ?? null,
            'action'   => $this->data['action'] ?? null,
            'action_id'   => $this->data['action_id'] ?? null,
            'type' => (string)($this->data['type'] ?? "1"),
            'course_id'=>$this->data['course_id']??null,
            // 'round_id' => $this->data['round_id']??null,
            'read_at' => $this->read_at !=null ? true : false,
            'time'    => Carbon::parse($this->created_at)->format('Y-m-d H:i'),
        ];
    }
}
