<?php

namespace App\Http\Resources\LectureQuestion;

use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\LectureQuestionCase\LectureQuestionCaseResource;

class LectureQuestionResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'               => $this->id,
            'lecture_id'       => $this->lecture_id,
            'question_type'    => $this->question_type,
            'question_content' => $this->getQuestionContent(),
            'listening_content'=>$this->getUrlAttribute(),
            'answer_writing'   =>$this->answer_writing,
            'tag'              => $this->whenLoaded('tag'),
            'options'          => $this->options,
            'case'             => $this->case,
            // 'case'             => new LectureQuestionCaseResource($this->whenLoaded('case')),
        ];
    }
}
