<?php

namespace App\Http\Resources\LectureAnswer;

use App\Http\Resources\LectureQuestion\LectureQuestionResource;
use Illuminate\Http\Resources\Json\JsonResource;

class LectureAnswerResource extends JsonResource
{
    public function toArray($request): array
    {
        return [
            'id'=> $this->id,
            'student_id'=> $this->student_id,
            'lecture_id'=> $this->lecture_id,
            'question_id'=> new LectureQuestionResource($this->question->load('tag','case')),
            'question_type'=> $this->question_type,
            'answer_content'=> $this->answer_content,
            'option_id'=> $this->option,
            'is_correct'=> $this->is_correct,
        ];
    }
}
