<?php

namespace App\Http\Resources\Installment;

use App\Enums\PaymentStatus;
use App\Http\Resources\Enrollment\EnrollmentResource;
use App\Http\Resources\Round\RoundResource;
use App\Http\Resources\Transaction\TransactionResource;
use App\Http\Traits\ResourceHelper;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class InstallmentResource extends JsonResource
{
    use ResourceHelper;

        /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
           'user' => [
                'id' => $this->user_id,
                'name' => $this->whenLoaded('user', function () {
                    return $this->user?->name;
                }),
            ],
            'course_enrollment_id' => $this->course_enro_id,
            'amount' => $this->amount,
            'due_date' => $this->due_date?->toDateString(),
            'paid_at' => $this->paid_at?->toDateString(),
            'status' => [
                'value' => $this->status->value,
                'label' => $this->status->name,
            ],
            'transactions' => $this->whenLoaded('transactions', function () {
                return TransactionResource::collection($this->transactions->load(['user', 'courseEnrollment.round', 'installment', 'acceptedBy']));
            }),
            'round' => $this->whenLoaded('courseEnrollment.round', function () {
                return new RoundResource($this->courseEnrollment->round);
            }),
            'course' => $this->when(
                $this->relationLoaded('courseEnrollment') &&
                optional($this->courseEnrollment)->relationLoaded('round') &&
                optional($this->courseEnrollment->round)->relationLoaded('course'),
                fn() => $this->courseEnrollment->round->course
            ),
            'created_by' => $this->created_by,
            'updated_by' => $this->updated_by,
            'created_at' => $this->created_at?->toDateTimeString(),
            'updated_at' => $this->updated_at?->toDateTimeString(),
        ];
    }
}
